<Query Kind="Statements">
  <Namespace>System.Runtime.Serialization</Namespace>
  <Namespace>System.Text.Json</Namespace>
  <Namespace>System.Text.Json.Serialization</Namespace>
</Query>

#load ".\Create sample JSON files.linq"

byte[] data = File.ReadAllBytes ("people.json");
Utf8JsonReader reader = new Utf8JsonReader (data);
while (reader.Read())
{
	switch (reader.TokenType)
	{
		case JsonTokenType.StartObject:
			Console.WriteLine ($"Początek obiektu");
			break;
		case JsonTokenType.EndObject:
			Console.WriteLine ($"Koniec obiektu");
			break;
		case JsonTokenType.StartArray:
			Console.WriteLine();
			Console.WriteLine ($"Początek tablicy");
			break;
		case JsonTokenType.EndArray:
			Console.WriteLine ($"Koniec tablicy");
			break;
		case JsonTokenType.PropertyName:
			Console.Write ($"Własność: {reader.GetString()}");
			break;
		case JsonTokenType.String:
			Console.WriteLine ($" Wartość: {reader.GetString()}");
			break;
		case JsonTokenType.Number:
			Console.WriteLine ($" Wartość: {reader.GetInt32()}");
			break;
		default:
			Console.WriteLine ($"Brak obsługi {reader.TokenType}");
			break;
	}
}